/*******************************************************************************
This .do files adds in data on age structure circa 1970 

*******************************************************************************/
clear all
set more off

cd "$insheet_files"
*===============================================================================
* Eurostata yearbook
*===============================================================================
cd "$insheet_files/Eurostat Regional Yearbook"
import excel using EYB_AGE_1973.xls, clear first

note: "Data from Eurostat Yearbook 1973, Table 5: Germany 1970, France 1968, Netherlands 1971, Italy 1971, Belgium 1970, UK 1971, Denmark 1971. ;

gen country=substr(nuts,1,2)
drop if nuts=="IE"|nuts=="LU0"|country=="DK"| ///
	(country=="UK" & nuts!="UKN") 

tempfile eyb_all
save 	`eyb_all.dta'

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* separate regions BE24 and BE31 from Brabant, BE1&BE24&BE31 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
keep if country=="BE"
mkmat age_* if nuts=="BE2", mat(BE2)
mkmat age_* if nuts=="BE3", mat(BE3)
matrix l=(1,1,1,1)
mkmat age_* if nuts=="BE21"|nuts=="BE22"|nuts=="BE23"|nuts=="BE25", mat(sumBE2)
matrix sumBE2=l*sumBE2
mkmat age_* if nuts=="BE32"|nuts=="BE33"|nuts=="BE34"|nuts=="BE35", mat(sumBE3)
matrix sumBE3=l*sumBE3
matrix BE24=BE2-sumBE2
matrix BE31=BE3-sumBE3

clear
svmat BE24, names(age)
gen nuts="BE24"

tempfile temp_be24
save 	`temp_be24.dta' 

clear
svmat BE31, names(age)
gen nuts="BE31"

append using `temp_be24.dta'
rename age1 age_total
rename age2 age_0_4
rename age3 age_5_9
rename age4 age_10_14
rename age5 age_15_19
rename age6 age_20_24
rename age7 age_25_29
rename age8 age_30_34
rename age9 age_35_39
rename age10 age_40_44
rename age11 age_45_49
rename age12 age_50_54
rename age13 age_55_59
rename age14 age_60_64
rename age15 age_65_69
rename age16 age_70_plus
gen country=substr(nuts,1,2)

tempfile BE_24_31
save 	`BE_24_31.dta' 

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Add duplicates with expanded nuts codes (e.g. add DE30 to DE3)
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

use `eyb_all.dta', clear

keep if nuts=="DE3"|nuts=="DE5"|nuts=="DE6"|nuts=="DEC"|nuts=="DEF"
replace nuts="DE30" if nuts=="DE3"
replace nuts="DE50" if nuts=="DE5"
replace nuts="DE60" if nuts=="DE6"
replace nuts="DEC0" if nuts=="DEC"
replace nuts="DEF0" if nuts=="DEF"

tempfile DE
save 	`DE.dta' 

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Aggregated regions of NL and IT to regular NUTS1 regions
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
use `eyb_all.dta', clear

gen NUTS1=""
replace NUTS1="NL3" if nuts=="NL31"|nuts=="NL31"|nuts=="NL33"|nuts=="NL34"
replace NUTS1="ITC" if nuts=="ITC1"|nuts=="ITC2"|nuts=="ITC3"|nuts=="ITC4"
replace NUTS1="ITF" if nuts=="ITF1"|nuts=="ITF2"|nuts=="ITF3"|nuts=="ITF4"|nuts=="ITF5"|nuts=="ITF6"
replace NUTS1="ITH" if nuts=="ITH1&ITH2"|nuts=="ITH3"|nuts=="ITH4"|nuts=="ITH5"
replace NUTS1="ITI" if nuts=="ITI1"|nuts=="ITI2"|nuts=="ITI3"|nuts=="ITI4"
replace NUTS1="ITG" if nuts=="ITG1"|nuts=="ITG2"
replace NUTS1="FR82&FR83" if nuts=="FR82"|nuts=="FR83"
drop if NUTS1==""

collapse (sum) age_* (first) region_name, by(NUTS1)

rename NUTS1 nuts

append using `eyb_all.dta'
append using `DE.dta'
append using `BE_24_31.dta'

sort nuts

tempfile eyb_1973
save 	`eyb_1973.dta'

*===============================================================================
* Spain (1970)
*===============================================================================
capture cd "$insheet_files/Spain"
import excel using "ES_AGE_1970.xlsx", clear first
gen age_70_plus=age_70_74+age_75_plus
drop age_70_74 age_75_plus

tempfile  nuts3
save 	 `nuts3.dta'

gen nuts2 = substr(nuts,1,4)

collapse (sum) age_*, by(nuts2)

rename nuts2 nuts
tempfile  nuts2
save 	 `nuts2.dta'

gen nuts1 = substr(nuts,1,3)

collapse (sum) age_*, by(nuts1)

rename nuts1 nuts
tempfile  nuts1
save 	 `nuts1.dta'

collapse (sum) age_*

gen nuts="ES"

append using `nuts1.dta'
append using `nuts2.dta'
append using `nuts3.dta'

tempfile ES_1970
save 	`ES_1970.dta'

*===============================================================================
* Denmark (1970)
*===============================================================================
cd "$insheet_files/Denmark"
import excel using "DK_AGE_1970.xlsx", first sheet("processed") clear  

collapse (sum) age*, by(nuts)

tempfile DK_nuts2
save `DK_nuts2.dta'

gen nuts1 = substr(nuts, 1,3)

collapse (sum) age*, by(nuts1)

rename nuts1 nuts

tempfile DK_nuts1
save `DK_nuts1.dta'

collapse (sum) age*

gen nuts = "DK"

append using `DK_nuts1.dta'
append using `DK_nuts2.dta'

tempfile DK_1970
save 	`DK_1970.dta'

*===============================================================================
* Austria (1971)
*===============================================================================
cd "$insheet_files/Austria"
import excel using "AT_AGE_1971.xlsx", first clear sheet("processed")

tempfile AT_nuts_1_2_3
save 	`AT_nuts_1_2_3.dta'

gen nuts_level	   = 1 if length(nuts)==3
keep if nuts_level==1 

collapse (sum) age* 

gen nuts= "AT"

append using `AT_nuts_1_2_3.dta'

tempfile AT_1971
save 	`AT_1971.dta' 
*==========================================================
* UK (1971) 
*==========================================================
cd "$insheet_files/UK"

*Bring in county districts
import excel using "Agg 1971Q.xls", sheet("1971") cellrange(A249:AS652) clear
	
drop if B==""
rename B localauthoritydistrictunitaryaut
rename C region_name
drop D
rename E age_total
rename F male_all_ages
rename G age_0_males
	
local bottom=1
local top=4
foreach var of varlist H-Y {
	quietly destring `var', replace force
	rename `var' age_`bottom'_`top'_males
	local bottom=`top'+1
	local top=`bottom'+4
}
	
	rename Z female_all_ages
	rename AA age_0_female
	local bottom=1
	local top=4

foreach var of varlist AB-AS {
	quietly destring `var', replace force
	rename `var' age_`bottom'_`top'_females
	local bottom=`top'+1
	local top=`bottom'+4
}
	
drop male_all_ages female_all_ages
	
gen age_0 = age_0_female + age_0_male
gen age_0_4 = age_0 + age_1_4_male + age_1_4_female
	
forval bottom = 5(5)85 {
	local top=`bottom'+4 
	egen age_`bottom'_`top'=rsum(age_`bottom'_`top'_male age_`bottom'_`top'_female)
}
	
drop age_0_female-age_85_89_female  age_0_male-age_85_89_male age_0
egen age_70_plus = rsum(age_70_74-age_85_89)
drop age_70_74-age_85_89
	
sort local
	
drop if local==""
	
*some new codes post 1980 based off old codes
gen local_new1="00"+substr(local,3,2) 
	replace localauthoritydistrictunitaryaut=local_new1 if A<=1625
	drop local_new
* Recode county districts that have since become Unitary Authorities (UA) 
* or have become defunct
* Where the UA does not share the same name, a brief description is given.
	replace local = "00HA" if local=="08UB"
	replace local = "00HB" if local=="08UC"
	replace local = "00HD" if local=="08UD" 
	replace local = "00HD" if local=="08UE" //Kingswood (above) and Northhavon merged to form South Gloucestershire
	replace local = "00HA" if local=="08UF" //Wandsdyke merged with the neighbouring City of Bath to form the unitary authority of Bath and North East Somerset
	replace local = "00HC" if local=="08UG" //This seat was renamed North Somerset
	replace local = "00KA" if local=="09UB" 
	replace local = "00MA" if local=="10UB"
	replace local = "00MB" if local=="10UC" //The constituency consists of most of West Berkshire
	replace local = "00MC" if local=="10UD"
	replace local = "00MD" if local=="10UE"
	replace local = "00ME" if local=="10UF"
	replace local = "00MF" if local=="10UG"
	replace local = "00MG" if local=="11UD"
	replace local = "00JA" if local=="12UF"
	replace local = "00ET" if local=="13UF"
	replace local = "00EU" if local=="13UJ"
	replace local = "00EB" if local=="14UB"
	replace local = "00EE" if local=="14UC" //Upon becoming a unitary authority, Langbaurgh-on-Tees (renamed as Redcar and Cleveland) 
	replace local = "00EC" if local=="14UD"
	replace local = "00EF" if local=="14UE"
	replace local = "00FK" if local=="17UE"
	replace local = "00HG" if local=="18UF"
	replace local = "00HH" if local=="18UJ"
	replace local = "00HN" if local=="19UB"
	replace local = "00HP" if local=="19UF"
	replace local = "00EH" if local=="20UC"
	replace local = "00ML" if local=="21UB" //Brighton joined Brighton & Hove UA
	replace local = "00ML" if local=="21UE" //Hove 
	replace local = "00KF" if local=="22UM"
	replace local = "00KG" if local=="22UP"
	replace local = "00MR" if local=="24UK"
	replace local = "00MS" if local=="24UM"
	replace local = "47UB" if local=="25UB"
	replace local = "00GA" if local=="25UC" //Hereford is a county town of Herefordshire, England. 
	replace local = "00GA" if local=="25UD" //Leominster is a market town in Herefordshire, England,
	replace local = "47UC" if local=="25UE"
	replace local = "47UD" if local=="25UF"
	replace local = "00GA" if local=="25UG" //in the County of Herefordshire
	replace local = "47UE" if local=="25UH"
	replace local = "47UF" if local=="25UJ"
	replace local = "47UG" if local=="25UK"
	replace local = "00FB" if local=="27UB"	//Unitary authority for Boothferry is East Riding of Yorkshire
	replace local = "00FC" if local=="27UC" //Unitary authority for Cleethorpes is North East Lincolnshire
	replace local = "00FB" if local=="27UD" //covers the northern part of the East Riding of Yorkshire unitary authority 
	replace local = "00FB" if local=="27UE" // Unitary authority for Beverly is East Riding of Yorkshire
	replace local = "00FD" if local=="27UF" //Glanford was merged with the Borough of Scunthorpe and part of the Borough of Boothferry to form the unitary authority of North Lincolnshire.
	replace local = "00FC" if local=="27UG" //Great Grimsby is a constituency in North East Lincolnshire 
	replace local = "00FB" if local=="27UH" //Holderness is an area of the East Riding of Yorkshire
	replace local = "00FA" if local=="27UJ" 
	replace local = "00FD" if local=="27UK" //Scunthorpe is a town in North Lincolnshire, England. It is the administrative centre of the North Lincolnshire unitary authority.
	replace local = "00MW" if local=="28UB" // Medina borough was abolished on 1 April 1995, when a single Isle of Wight Council replaced the Island's county council and two district council
	replace local = "00MW" if local=="28UC" //South Wight  was abolished on 1 April 1995, when a single Isle of Wight Council replaced the island's county council and two district councils
	replace local = "00LC" if local=="29UF" //Gillingham is a town in the unitary authority of Medway
	replace local = "00LC" if local=="29UJ" //Rochester upon Medway  was abolished on 1 April 1998, when it was merged with the neighbouring Borough of Gillingham to form a new unitary authority of Medway
	replace local = "00EX" if local=="30UB"
	replace local = "00EY" if local=="30UC"
	replace local = "00FN" if local=="31UF"
	replace local = "00FP" if local=="31UK"
	replace local = "00FF" if local=="36UJ"
	replace local = "00FY" if local=="37UH"
	replace local = "00GF" if local=="39UG" //Parliament approved major boundary changes which took effect at the 1997 general election, which created a new constituency containing and named after the town of Telford.
	replace local = "00GL" if local=="41UJ"
	replace local = "00HX" if local=="46UE" //Borough of Swindon forms part of the ceremonial county of Wiltshire. It was formed in 1974 as the Thamesdown district of Wiltshire
	replace local = "00NJ" if local=="56UB" //Alyn and Deeside district was abolished on 1 April 1996, and its area included in the larger unitary authority of Flintshire.
	replace local = "00NE" if local=="56UC" //The borough was abolished in 1996, when wales was divided into unitary authorities created by the Local Government (Wales) Act 1994. The area of Colwyn was split: a large part going to Aberconwy and Colwyn county borough, (soon renamed as Conwy), and the remainder going to Denbighshire unitary authority.
	replace local = "00NJ" if local=="56UD" // Flintshire was formed in 1996 under the Local Government (Wales) Act 1994, consisting only of the Alyn and Deeside and Delyn districts 
	replace local = "00NG" if local=="56UE" //Glyndwr. Unitary Authority Denbighshire
	replace local = "00NG" if local=="56UF" //Rhuddlan district was abolished in 1996, with its area forming part of the Denbighshire unitary authority.
	replace local = "00NL" if local=="56UG" //The region is governed as a unitary authority 
	replace local = "00NU" if local=="57UB"
	replace local = "00NQ" if local=="57UC"
	replace local = "00NU" if local=="57UD" //Carmarthenshire took over local government functions previously provided by Carmarthen District, Dinefwr Borough and Llanelli Borough councils.
	replace local = "00NU" if local=="57UE" //see above
	replace local = "00NS" if local=="57UF" //On April 1, 1996 the district was abolished by the Local Government (Wales) Act 1994 and merged into a reconstituted county of Pembrokeshire.
	replace local = "00NS" if local=="57UG"
	replace local = "00PL" if local=="58UB"
	replace local = "00PK" if local=="58UC" // ISLWYN part of the new Caerphilly County Borough Council unitary authority.
	replace local = "00PP" if local=="58UD"
	replace local = "00PR" if local=="58UE"
	replace local = "00PM" if local=="58UF"
	replace local = "00NE" if local=="59UB" // Aberconwy passed to the new Conwy County Borough.
	replace local = "00NC" if local=="59UC" //Arfon was abolished as a district on 1 April 1996, when Gwynedd was reconstituted as a unitary authority. 
	replace local = "00NC" if local=="59UD" //now part of Gwynedd
	replace local = "00NC" if local=="59UE" //Meirionnydd District was abolished in 1996 by the Local Government (Wales) Act 1994, becoming part of the unitary authority of 'Caernarfonshire and Merionethshire', which was immediately renamed Gwynedd as the first act of the new council
	replace local = "00NA" if local=="59UF"
	replace local = "00PF" if local=="60UB"
	replace local = "00PH" if local=="60UC"
	replace local = "00PB" if local=="60UD" //In 1996, following further local government reorganisation, Ogwr District Council became part of the unitary authority of Bridgend County Borough Council
	replace local = "00PF" if local=="60UE"
	replace local = "00PK" if local=="60UF" //local Unitary Authority, Caerphilly County Borough Council.
	replace local = "00PF" if local=="60UG" //Rhondda Cynon Taf is a county borough in the South Wales Valleys of Wales. It consists of 3 valleys: the Rhondda Valley, Cynon Valley and Taff-Ely Valley.
	replace local = "00NN" if local=="61UB" //The administrative county of Brecknock was abolished in 1974 by the Local Government Act 1972. The bulk of its area passed to the new county of Powys, In 1996 a further reorganisation of local government took place in Wales, and Powys became a unitary authority.
	replace local = "00NN" if local=="61UC" //Montgomeryshire today constitutes the northern part of the principal area of Powys.Further local government reform in 1996 abolished district councils in Wales, making Powys a unitary authority.
	replace local = "00NN" if local=="61UD" //Radnorshire is represented by the Radnorshire area of Powys
	replace local = "00PT" if local=="62UB"
	replace local = "00PD" if local=="62UC"
	replace local = "00NX" if local=="63UB" //Lliw Valley part of Swansea unitary authority
	replace local = "00NZ" if local=="63UC"
	replace local = "00NZ" if local=="63UD"
	replace local = "00NX" if local=="63UE"
		
merge m:m localauthoritydistrictunitaryaut using  /// 
"$insheet_files/UK/crosswalk_2006_nuts_unitary_authority_county_districts.dta", /// 
	gen(_merge_local)	 

drop if _merge_local==2
	
* III. collapse local areas to a single NUTS 3 region
	
collapse (sum) age*, by(nuts)
			
tempfile UK_nuts3
save `UK_nuts3.dta'
	 
* IV. Generate Nuts 1 & 2 codes from the NUTS 3 codes  
	
gen nuts2=substr(nuts,1,4)
	
collapse (sum) age*, by(nuts2) 
	
rename nuts2 nuts
	
tempfile UK_nuts2
save `UK_nuts2.dta'
		
gen nuts1=substr(nuts,1,3)

collapse (sum) age*, by(nuts1) 

rename nuts1 nuts

tempfile UK_nuts1
save `UK_nuts1.dta'

collapse (sum) age*

gen nuts= "UK" 

append using `UK_nuts1.dta'		
append using `UK_nuts2.dta'	
append using `UK_nuts3.dta'	

			
********************************************************************************
*NUTS codes are NUTS 2003. Need to convert to NUTS 2006 then to NUTS 2010.

*Code change

replace nuts ="UKM5" if nuts=="UKM1"
replace nuts ="UKM6" if nuts=="UKM4"
replace nuts ="UKD72" if nuts=="UKD52"
replace nuts ="UKD73" if nuts=="UKD53"
replace nuts ="UKD74" if nuts=="UKD54"
replace nuts ="UKM50" if nuts=="UKM10"
replace nuts ="UKM61" if nuts=="UKM41"
replace nuts ="UKM62" if nuts=="UKM42"
replace nuts ="UKM63" if nuts=="UKM43"
replace nuts ="UKM64" if nuts=="UKM44"
replace nuts ="UKM65" if nuts=="UKM45"
replace nuts ="UKM66" if nuts=="UKM46"

*Boundary shifts
replace nuts="UKD6" if nuts=="UKD2"
replace nuts="UKD7" if nuts=="UKD5"
replace nuts="UKD61" if nuts=="UKD21"
replace nuts="UKD71" if nuts=="UKD51"

*3) Splits. Create a composite region of NUTS 2010 codes from NUTS 2006 code. 

replace nuts = "UKD62&UKD63" if nuts== "UKD22"
replace nuts = "UKE44&UKE45" if nuts== "UKE43"
replace nuts = "UKF24&UKF25" if nuts== "UKF23"
replace nuts = "UKG36&UKG37" if nuts== "UKG34"
replace nuts = "UKG38&UKG39" if nuts== "UKG35"
replace nuts = "UKH24&UKH25" if nuts== "UKH22"

*Save UK data
sort nuts 
tempfile UK_1971
save 	`UK_1971.dta' 

*==============================================================================*
* Finland  (1970) 												//new 10.09.13 dkk 
*==============================================================================*
cd "$insheet_files/Finland"
import excel  "FI_AGE_1970", first sheet("Sheet1") clear

note: FI age breakdown: since no age breakdown given for ages 65-69 (only 65+ is given), this age group is assumed to be 94% of ages 60-64. 94% is the ratio of 60-64/55-59

egen age_total = rsum(age_*)

collapse (sum) age*, by(nuts)

tempfile FI_1970
save    `FI_1970.dta'

*===============================================================================
* Sweden (1970)
*===============================================================================
cd "$insheet_files/Sweden"

import excel "SE_AGE_1970.xlsx", first clear

tempfile  nuts3
save 	 `nuts3.dta'

gen nuts2 = substr(nuts,1,4)

collapse (sum) age_*, by(nuts2)

rename nuts2 nuts
tempfile  nuts2
save 	 `nuts2.dta'

gen nuts1 = substr(nuts,1,3)

collapse (sum) age_*, by(nuts1)

rename nuts1 nuts
tempfile  nuts1
save 	 `nuts1.dta'

collapse (sum) age_*

gen nuts="SE"

append using `nuts1.dta'
append using `nuts2.dta'
append using `nuts3.dta'

tempfile SE_1970
save 	`SE_1970.dta'

*===============================================================================
* Switzerland (1970)
*===============================================================================
cd "$insheet_files/Switzerland"
import excel using "CH_AGE_1970.xlsx", first clear 

tempfile CH_1970
save	`CH_1970.dta'

*===============================================================================
* Merge data
*===============================================================================
use `eyb_1973.dta'

append using `AT_1971.dta' 
append using `CH_1970.dta'
append using `DK_1970.dta' 
append using `ES_1970.dta'
append using `FI_1970.dta'
append using `UK_1971.dta'
append using `SE_1970.dta' 

drop country
save "$dta_files/IC_EU_AGE", replace

